format long;
%--------------------------------------------------------------------------
%                         ***unos podataka***
eps=input('Unesite zeljenu tacnost epsilon : ');
%--------------------------------------------------------------------------
%       ***podaci sracunati sa strane (objasnjenja i uslovi u help.txt)***
a1=-2;          %levi kraj prvog intervala (sa nulom)
b1=1.9;         %desni kraj prvog intervala (sa nulom)
a2=2.1;         %levi kraj drugog intervala (sa nulom)
b2=5;           %desni kraj drugog intervala (sa nulom)
m1=abs(fprim(1.9));      %minimum apsolutne vrednosti prvog izvoda na [-2,1.9]
m2=abs(fprim(2.1));      %minimum apsolutne vrednosti prvog izvoda na [2.1,5]
%--------------------------------------------------------------------------
%               ***pronalazenje resenja pomocu f-ja*** 
[x1 n1]=newton(a1,b1,eps,m1);       %prvo resenje Njutnovom metodom
[x2 n2]=newton(a2,b2,eps,m2);       %drugo resenje Njutnovom metodom
[x3 n3]=combin(a1,b1,eps);          %prvo resenje Kombinovanom metodom
[x4 n4]=combin(a2,b2,eps);          %drugo resenje Kombinovanom metodom
%--------------------------------------------------------------------------
%                        ***ispis rezultata***
disp('Resenja dobijena Njutnovom metodom tangente :');
disp('        resenja        broj iteracija');
disp([x1 n1]);
disp([x2 n2]);
disp('Resenja dobijena Kombinovanom metodom :');
disp('        resenje        broj iteracija');
disp([x3 n3]);
disp([x4 n4]);
%--------------------------------------------------------------------------
%                        ***crtanje grafika***
k=1e-007:4*1e-007:1e-003;
[m n]=size(k);
for i=1:n
[p1 y1(i)]=newton(a1,b1,k(i),m1);
[q1 y2(i)]=combin(a1,b1,k(i));
[p2 y3(i)]=newton(a2,b2,k(i),m1);
[q2 y4(i)]=combin(a2,b2,k(i));
end
subplot(2,1,1),
plot(k,y1,'r-',k,y2,'k:');      %grafik za [-2,1.9]
ylim([2 5]);
xlabel('Tacnost(epsilon)');
ylabel('Broj iteracija');
title('Zavisnost brzine konvergencije od tacnosti (na intervalu [-2,1.9])')
legend('Njutnova metoda tangente','Kombinovana metoda');
subplot(2,1,2),
plot(k,y3,'r-',k,y4,'k:');      %grafik za [2.1,5]
ylim([5 8]);
xlabel('Tacnost(epsilon)');
ylabel('Broj iteracija');
title('Zavisnost brzine konvergencije od tacnosti (na intervalu [2.1,5])')
legend('Njutnova metoda tangente','Kombinovana metoda');
clear all;